'
' Egzemplarze tej klasy identyfikuj pracownikw.
'
Public Class EmployeeID
    Private id As String

    '
    ' Konstruktor
    '
    ' id  acuch acuch zawierajcy identyfikator pracownika.
    Public Sub New(ByVal id As String)
        Me.id = id
    End Sub

    '
    ' Zwraca warto kodu dla tego obiektu.
    '
    Public Overrides Function GetHashCode() As Integer
        Return id.GetHashCode()
    End Function 'GetHashCode

    '
    ' Zwraca warto true, jeli dany obiekt jest identyfikatorem pracownika
    ' rwnym identyfikatorowi przekazanemu za porednictwem argumentu.
    ' o  Obiekt obiekt porwnywany z danym obiektem.
    Public Overloads Function Equals(ByVal o As Object) As Boolean
        ' Sprawdza, czy nie przekazano wartoci Nothing, oraz czy typ przekazanego obiektu jest prawidowy.
        If (o Is Nothing) Or (TypeOf o Is EmployeeID) Then
            Return False
        End If
        Return id.Equals(CType(o, EmployeeID).id)
    End Function 'Equals

    '
    ' Zwraca acuchow reprezentacj tego obiektu klasy EmployeeID.
    '
    Public Overrides Function ToString() As String
        Return id
    End Function

End Class 'EmployeeID
